/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.block;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.block.info.BlockDirection;
import com.raoulvdberge.refinedstorage.block.info.IBlockInfo;
import com.raoulvdberge.refinedstorage.item.itemblock.ItemBlockBase;
import com.raoulvdberge.refinedstorage.render.IModelRegistration;
import com.raoulvdberge.refinedstorage.render.collision.AdvancedRayTraceResult;
import com.raoulvdberge.refinedstorage.render.collision.AdvancedRayTracer;
import com.raoulvdberge.refinedstorage.render.collision.CollisionGroup;
import com.raoulvdberge.refinedstorage.tile.TileBase;
import com.raoulvdberge.refinedstorage.util.CollisionUtils;
import com.raoulvdberge.refinedstorage.util.WorldUtils;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;

public abstract class BlockBase
extends Block {
    private static final CollisionGroup DEFAULT_COLLISION_GROUP = new CollisionGroup().addItem(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)).setCanAccessGui(true);
    private static final List<CollisionGroup> DEFAULT_COLLISION_GROUPS = Collections.singletonList(DEFAULT_COLLISION_GROUP);
    protected final IBlockInfo info;

    public BlockBase(IBlockInfo info) {
        super(info.getMaterial());
        this.info = info;
        this.func_149711_c(info.getHardness());
        this.setRegistryName(info.getId());
        this.func_149647_a(RS.INSTANCE.tab);
        this.func_149672_a(info.getSoundType());
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels(IModelRegistration modelRegistration) {
    }

    @Nonnull
    public String func_149739_a() {
        return "block." + this.info.getId().toString();
    }

    protected BlockStateContainer.Builder createBlockStateBuilder() {
        BlockStateContainer.Builder builder = new BlockStateContainer.Builder((Block)this);
        if (this.getDirection() != null) {
            builder.add(new IProperty[]{this.getDirection().getProperty()});
        }
        return builder;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return this.createBlockStateBuilder().build();
    }

    public Item createItem() {
        return new ItemBlockBase(this, false);
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(@Nonnull IBlockState state) {
        return 0;
    }

    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        TileEntity tile;
        if (this.getDirection() != null && (tile = world.func_175625_s(pos)) instanceof TileBase) {
            return state.func_177226_a((IProperty)this.getDirection().getProperty(), (Comparable)((TileBase)tile).getDirection());
        }
        return state;
    }

    public int func_180651_a(@Nonnull IBlockState state) {
        return this.func_176201_c(state);
    }

    public boolean rotateBlock(World world, @Nonnull BlockPos pos, @Nonnull EnumFacing axis) {
        if (!world.field_72995_K && this.getDirection() != null) {
            TileBase tile = (TileBase)world.func_175625_s(pos);
            EnumFacing newDirection = this.getDirection().cycle(tile.getDirection());
            tile.setDirection(newDirection);
            WorldUtils.updateBlock(world, pos);
            return true;
        }
        return false;
    }

    public void func_180663_b(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        this.dropContents(world, pos);
        this.removeTile(world, pos, state);
    }

    void removeTile(World world, BlockPos pos, IBlockState state) {
        if (this.hasTileEntity(state)) {
            world.func_175713_t(pos);
        }
    }

    void dropContents(World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof TileBase)) {
            return;
        }
        IItemHandler drops = ((TileBase)tile).getDrops();
        if (drops == null) {
            return;
        }
        WorldUtils.dropInventory(world, pos, drops);
    }

    public boolean removedByPlayer(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player, boolean willHarvest) {
        return willHarvest || super.removedByPlayer(state, world, pos, player, false);
    }

    public void func_180657_a(@Nonnull World world, @Nonnull EntityPlayer player, @Nonnull BlockPos pos, @Nonnull IBlockState state, TileEntity tile, @Nonnull ItemStack stack) {
        super.func_180657_a(world, player, pos, state, tile, stack);
        world.func_175698_g(pos);
    }

    public final boolean hasTileEntity(@Nonnull IBlockState state) {
        return this.info.hasTileEntity();
    }

    public final TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return this.info.createTileEntity();
    }

    @Nullable
    public BlockDirection getDirection() {
        return null;
    }

    public final IBlockInfo getInfo() {
        return this.info;
    }

    protected boolean canAccessGui(IBlockState state, World world, BlockPos pos, float hitX, float hitY, float hitZ) {
        state = this.func_176221_a(state, (IBlockAccess)world, pos);
        for (CollisionGroup group : this.getCollisions(world.func_175625_s(pos), state)) {
            if (!group.canAccessGui()) continue;
            for (AxisAlignedBB aabb : group.getItems()) {
                if (!CollisionUtils.isInBounds(aabb, hitX, hitY, hitZ)) continue;
                return true;
            }
        }
        return false;
    }

    public List<CollisionGroup> getCollisions(TileEntity tile, IBlockState state) {
        return DEFAULT_COLLISION_GROUPS;
    }

    public void func_185477_a(@Nonnull IBlockState state, World world, @Nonnull BlockPos pos, @Nonnull AxisAlignedBB entityBox, @Nonnull List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean isActualState) {
        for (CollisionGroup group : this.getCollisions(world.func_175625_s(pos), this.func_176221_a(state, (IBlockAccess)world, pos))) {
            for (AxisAlignedBB aabb : group.getItems()) {
                BlockBase.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)aabb);
            }
        }
    }

    public RayTraceResult func_180636_a(@Nonnull IBlockState state, World world, @Nonnull BlockPos pos, @Nonnull Vec3d start, @Nonnull Vec3d end) {
        AdvancedRayTraceResult<RayTraceResult> result = AdvancedRayTracer.rayTrace(pos, start, end, this.getCollisions(world.func_175625_s(pos), this.func_176221_a(state, (IBlockAccess)world, pos)));
        return result != null ? result.getHit() : null;
    }
}

